/*
  Low_Power.c
*/

#include "m51em256evb.h"
#include "low_power.h"

//thsi function also disables GPIO clocks and mux control
//each module must explicitily turn clock on
void disable_all_clocks()
{
    /*turning off unused peripherals*/
    SCGC1=0x00;       
    SCGC2=0x00; 
    SCGC3=0x00;
    SCGC4=0x00;
    SCGC5=0x00;
}

/*low power init*/
void low_power_init(enum low_power_modes mode)
{
    switch(mode)
    {
      case RUN_MODE:
           SOPT1 = 0;/*COP off, Minibus access off*///ATX:SOPT1_STOPE_MASK
           SPMSC1 = 0;/*turn off low voltage stuff*/
           SPMSC2 = 0;
        break;
      case LPRUN:
           SOPT1 = 0;/*COP off, Minibus access off*///ATX:SOPT1_STOPE_MASK 
           SPMSC1 = 0;/*turn off low voltage stuff*/
           SPMSC2 = 0 | SPMSC2_LPR_MASK;
        break;             
      case LPWAIT:
           SOPT1 = 0 | SOPT1_WAITE_MASK;/*COP off, Minibus access off, WAIT mode*/
           SPMSC1 = 0 | SPMSC1_LVDE_MASK;
           SPMSC2 = 0 | SPMSC2_LPR_MASK;
        break;
      case NON_STOP:
           SOPT1 = 0;/*COP off, Minibus access off*/
           SPMSC1 = 0 | SPMSC1_LVDE_MASK | SPMSC1_LVDSE_MASK;
           SPMSC2 = 0;
        break;
      /*low power modes needed with stop asm instruction*/  
      case WAIT:
           SOPT1 = 0;/*COP off, Minibus access off, WAIT mode*///ATX: SOPT1_WAITE_MASK
           SPMSC1 = 0 | SPMSC1_LVDE_MASK | SPMSC1_LVDSE_MASK;//AUTX:0
           SPMSC2 = 0;
        break;         
      case STOP4:
           SOPT1 = 0 | SOPT1_STOPE_MASK;/*COP off, Minibus access off, STOP mode*/
           SPMSC1 = 0;/*turn off low voltage stuff*///ATX: 0x0C
           SPMSC2 = 0;//ATX: 0x02
        break;
      case STOP3:
           SOPT1 = 0 | SOPT1_STOPE_MASK;/*COP off, Minibus access off, STOP mode*/
           SPMSC1 = 0;/*turn off low voltage stuff*/
           SPMSC2 = 0;//partial power down//ATX: SPMSC2_PPDE_MASK
        break;
      case STOP2:
           SOPT1 = 0 | SOPT1_STOPE_MASK;/*COP off, Minibus access off, STOP mode*/
           SPMSC1 = 0;/*turn off low voltage stuff*/
           SPMSC2 = 0 | SPMSC2_PPDE_MASK | SPMSC2_PPDC_MASK;//partial power down           
        break;                               
    }
}


/*FSL: low level init*/
void pinout_init()
{   
    //disable pull up
    PTAPE = 0x00; 
    PTBPE = 0x00; 
    PTCPE = 0x00;  
    PTDPE = 0x00; 
    PTEPE = 0x00; 
    PTFPE = 0x00;  
     
    //disable slew control
    PTASE = 0x00; 
    PTBSE = 0x00; 
    PTCSE = 0x00;  
    PTDSE = 0x00; 
    PTESE = 0x00; 
    PTFSE = 0x00;  
    
    //enable low drive strength
    PTADS = 0x00; 
    PTBDS = 0x00; 
    PTCDS = 0x00;  
    PTDDS = 0x00; 
    PTEDS = 0x00; 
    PTFDS = 0x00;      
    
    //Turn off input filtering
    PTAIFE = 0;
    PTBIFE = 0;
    PTCIFE = 0;
    PTDIFE = 0;
    PTEIFE = 0;
    PTFIFE = 0;
    
    //set all I/O in general I/O mode
    PTAPF1 = 0x00;
    PTAPF2 = 0x00;
    PTBPF1 = 0x00;
    PTBPF2 = 0x00;
    PTCPF1 = 0x00;
    PTCPF2 = 0x00;
    PTDPF1 = 0x00;
    PTDPF2 = 0x00;
    PTEPF1 = 0x00;
    PTEPF2 = 0x00;
    PTFPF1 = 0x00;
    PTFPF2 = 0x00;
    
    //set all pin in output mode
    PTADD = 0xFF;
    PTBDD = 0xFF;
    PTCDD = 0xFF;
    PTDDD = 0xFF;
    PTEDD = 0xFF;
    PTFDD = 0xFF;
    
    //clear output
    PTACLR =  0xFF;
    PTBCLR =  0xFF;
    PTCCLR =  0xFF;
    PTDCLR =  0xFF;
    PTECLR =  0xFF;
    PTFCLR =  0xFF;
}

/*FSL: generic low level init: here for legacy: no low power at all*/
void MCU_init()
{
  /*stop not enabled*/
  /*wait not enabled*/
  /*cop disabled*/
  SOPT1 = 0x00;
  
}

/********************************************************************/
/*                        Setup for system clock                     /
/********************************************************************/
